local pn=...;
local t=Def.ActorFrame{};
if not GAMESTATE:IsPlayerEnabled(pn) then
	return t;
end;

local RadarPrm={"Stream","Chaos","Freeze","Air","Voltage"};
local keymode=false;
local exsong_inf={};
local exsong_fol={};
local sys_selsong=1;
local sys_load=false;

t[#t+1]=Def.ActorFrame{
	PlayerJoinedMessageCommand=cmd(playcommand,"Joined");
	OnCommand=cmd(playcommand,"Joined");

	LoadActor(THEME:GetPathG("_ScreenSelectMusic","GrooveRadar/_GrooveRadar base"))..{
		InitCommand=function(self)
			self:diffuse(PlayerColor(pn));
			self:diffusealpha(1.0);
		end;
	};
	LoadActor(THEME:GetPathG("_SelectMusic/white","difficulty (doubleres)"))..{
		InitCommand=function(self)
			self:zoom(1.1);
			self:diffusealpha(0.5);
			self:blend('BlendMode_Add');
		end;
	};
	--[[
	LoadActor(THEME:GetPathG("_ScreenSelectMusic","GrooveRadar/_GrooveRadar over"))..{
		InitCommand=function(self)
			self:diffuse(Color("White"));
			self:diffusealpha(1.0);
			self:blend('BlendMode_Add');
		end;
	};
	--]]

};
t[#t+1]=Def.ActorFrame{
	InitCommand=cmd(playcommand,"Joined");
	PlayerJoinedMessageCommand=cmd(queuecommand,"Joined";);
	LoadActor(THEME:GetPathG("_ScreenSelectMusic","GrooveRadar/_GrooveRadar autogen"))..{
		ChangedCommand=function(self)
			if step then
				if step:IsAutogen() then
					self:stoptweening();
					self:x((pn==PLAYER_1) and -42 or 42);
					self:y(-55);
					self:zoomy(1);
					self:glowblink();
					self:effectperiod(0.80);
					self:visible(1);
				else
					self:visible(0);
				end;
			else
				self:visible(0);
			end;
		end;
	};
	Def.GrooveRadar {
		InitCommand=function(self)
			self:diffuse(BoostColor(PlayerColor(pn),1.0));
			self:zoom(1.3);
		end;
		ChangedCommand=function(self)
			local rv=GAMESTATE:GetCurrentSteps(pn):GetRadarValues(pn);
			local v={};
			local song=_SONG();
			if not song or not sys_load or bitand(exsong_inf[exsong_fol[sys_selsong].."-Hidden"],1)==1 then
				self:SetEmpty(pn);
			else
				v[#v+1]=yaGetRadarVal(song,pn,'Stream',false)*0.01;
				v[#v+1]=yaGetRadarVal(song,pn,'Voltage',false)*0.01;
				v[#v+1]=yaGetRadarVal(song,pn,'Air',false)*0.01;
				v[#v+1]=yaGetRadarVal(song,pn,'Freeze',false)*0.01;
				v[#v+1]=yaGetRadarVal(song,pn,'Chaos',false)*0.01;
				self:SetFromValues(pn,v);
			end;
		end;
	};
};

local radar_name={"STR","CHA","FRZ","AIR","VOL"};
for i=1,5 do
t[#t+1]=Def.ActorFrame{
	LoadFont("Common Normal")..{
		InitCommand=function(self)
			self:player(pn);
			self:x(55.0*math.sin(2*math.pi*(i-1)/5));
			self:y(55.0*math.cos(2*math.pi*(i-1)/5)*(-1));
			self:rotationz(360*(i-1)/5);
			self:diffuse(Color("Black"));
			self:strokecolor(Color("White"));
			self:settextf("%s",radar_name[i]);
			self:diffusealpha(0);
			self:zoom(0);
			self:sleep(_TT.S_IN);
		end;
		OnCommand=function(self)
			self:decelerate(0.2);
			self:diffusealpha(0.5);
			self:zoom(0.5);
		end;
		PlayerJoinedMessageCommand=cmd(queuecommand,"Init";queuecommand,"Joined");
	};
};
end;

setenv("radar_chg",false);
local old_step=nil;
local function update(self)
	if _SONG() then
		local st=_STEPS2(pn);
		if old_step~=st then
			old_step=st;
			self:playcommand("Changed");
		end;
	else
		if old_step~=nil then
			old_step=nil;
			self:playcommand("Changed");
		end;
	end;
	if not sys_load and getenv("exsong_flag")=="decorations" then
		exsong_inf=getenv("exsong_inf");
		exsong_fol=getenv("exsong_fol");
		sys_selsong=getenv("sys_selsong");
		sys_load=true;
		self:queuecommand("Changed");
	end;
	if getenv("exsong_chg") and not getenv("radar_chg") then
		sys_selsong=getenv("sys_selsong");
		setenv("radar_chg",true);
		self:queuecommand("Changed");
	end;
end;

t.InitCommand=cmd(player,pn;SetUpdateFunction,update;);

return t;